/* Spells */

function Spell(name, cost, image)
{
	this.name = name;
	this.cost = cost;
	this.image = LoadImage(image);
	this.effect = function(){};
	this.timer = 0;
	this.updateFunc = function(){};
}

var Spells = [];
Spells[0] = new Spell("Lay Mud", 5, "LayMud.png");
Spells[0].effect = function()
{
	Game.mana -= this.cost;
	var x = Math.floor(Cursor.mapX/16);
	var y = Math.floor(Cursor.mapY/16);
	var o_tile = GetTile(x, y, 0);
	SetTile(x, y, 0, 2);
	this.timer = GetTime();
	this.tile = {x: x, y: y, index: o_tile};
	this.updateFunc = function()
	{
		if (this.timer + 15000 < GetTime())
		{
			SetTile(this.tile.x, this.tile.y, 0, this.tile.index);
			SpellEffects.splice(SpellEffects.indexOf(this), 1);
		}
	}
	SpellEffects.push(this.clone());
}
Spells[1] = new Spell("Lightning", 10, "Lightning.png");
Spells[1].effect = function()
{
	this.target = GetClosestEnemy(Cursor.mapX, Cursor.mapY, 16);
	if (this.target != null)
	{
		this.target.hp -= 40;
		Game.mana -= this.cost;
	}
}

var SpellEffects = [];

function UpdateSpells()
{
	var i = SpellEffects.length;
	while(i--) { SpellEffects[i].updateFunc(); }
}